/****** Object:  StoredProcedure [dbo].[usp_Get_Discharge_Event]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Get_Discharge_Event]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Get_Discharge_Event]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		SILVICAP	
-- Create date: 24.10.2012
-- Description:	Get discharge event by ID.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Get_Discharge_Event] 
	@ID	INT = NULL,
	@DOMAIN_ID NVARCHAR(50) = NULL
AS
BEGIN
SET NOCOUNT ON
	
	SELECT 
		[DE].[ID],
		[DE].[ENTERED_DATE],
		[DE].[DOMAIN_ID],
		[DE].[IEN],
		[DE].[PATIENT_UID],
		[DE].[WARD_UID],
		[DE].[BED_UID] ,
		[DE].[VISTA_SITE_UID],					
		[DE].[DISCHARGED_DATE],
		[DE].[ENTERED_BY_UID],
		[TOM].[CODE] AS [TYPE_OF_MOVEMENT_CODE],
		[TOM].[CODE_SYSTEM] AS [TYPE_OF_MOVEMENT_CODE_SYSTEM],
		[TOM].[CODE_SYSTEM_NAME] AS [TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME],
		[TOM].[DISPLAY_NAME] AS [TYPE_OF_MOVEMENT_DISPLAY_NAME],
		[DE].[ADMISSION_ID]
	FROM DISCHARGE_EVN DE 				
		LEFT JOIN CONCEPT AS TOM ON DE.TYPE_OF_MOVEMENT_ID = TOM.ID
	WHERE [DE].[ID] = @ID AND [DE].[DOMAIN_ID] = @DOMAIN_ID
END
GO